<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>EMO Print — Upload #<?php echo e($upload->id); ?></title>
    <style>
        @page { size: A4 portrait; margin: 0; }
        body {
            margin:0; font-family: DejaVu Sans, Arial, sans-serif; color:#000;
            -webkit-print-color-adjust:exact; print-color-adjust:exact;
        }

        .page {
            width: 210mm; height: 297mm;  /* A4 */
            margin: auto;
            position: relative;
            page-break-after: always;
        }

        /* Center Content */
        .content {
            position: absolute;
            top: 40%;
            left: 50%;
            transform: translate(-50%, -50%);
            text-align: left;
            font-size: 12pt;
            width: 180mm; /* adjust width as needed */
            line-height: 1.6;
        }

        .row {
            display: flex;
            justify-content: space-between;
            margin-bottom: 6mm;
        }

        .lbl { font-weight: bold; margin-right: 4mm; }
    </style>
</head>
<body onload="window.print()">

<?php $__currentLoopData = $records; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $r): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <div class="page">
        <div class="content">
            <!-- Row 1 -->
            <div class="row">
                <div><span class="lbl">EMO No:</span> <?php echo e($r->emo_number); ?></div>
                <div><span class="lbl">Received Rs.</span> ₹<?php echo e(number_format($r->emo_amount, 2)); ?> (<?php echo e(\App\Helpers\NumberHelper::convertToIndianCurrency($r->emo_amount)); ?>)</div>
                <div><span class="lbl">Dated:</span> <?php echo e(now()->format('d/m/Y')); ?></div>
            </div>

            <!-- Row 2 -->
          <div class="row" style="display:flex; gap:10px;">
			<div style="flex:1;"><?php echo e($r->sender_name); ?></div>
			<div style="flex:2;"><?php echo e($r->sender_address); ?>, <?php echo e($r->sender_pincode); ?></div>
		</div>
        </div>
    </div>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

</body>
</html>
<?php /**PATH C:\project\laravel_project\emo-receipts\resources\views/emo/print.blade.php ENDPATH**/ ?>