<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Receipt Print — Upload #<?php echo e($upload->id); ?></title>
    <style>
        @page { size: A4 portrait; margin: 10mm; }
        body {
            margin:0; font-family: DejaVu Sans, Arial, sans-serif; color:#000;
            -webkit-print-color-adjust:exact; print-color-adjust:exact;
            background:#E7E1D2;
        }

        .page {
            width: 190mm; min-height: 277mm;
            margin:auto;
            border: 1px dashed #ddd; background:#E7E1D2;
            page-break-after:always; position:relative;
        }

        /* Header */
        .header { text-align:center; margin-bottom:4mm; }
        .header img { max-width:100%; height:auto; }

        /* Content box */
        .box {
            border:1px solid #004080;
            padding:4mm 6mm;
            border-radius:4px;
        }
        .line { margin:1.8mm 0; font-size:10.5pt; }
        .two { display:flex; justify-content:space-between; gap:6mm; }
        .lbl { font-weight:600; color:#000; }
        .right { text-align:right; }

        /* Blessing */
        .blessing {
            text-align:center;
            font-weight:600;
            font-size:10.5pt;
            color:#b00000;
            margin:4mm 0;
        }

        /* Signature */
        .sign {
            text-align:right;
            font-size:10.5pt;
            line-height:1.4;
        }

        /* Footer */
        .footer {
            position:absolute; left:0; right:0; bottom:0;
            background:linear-gradient(to top, #a3c8ff, #e9f1ff);
            border-top:1px solid #7aa6e0;
            text-align:center;
            padding:3mm 2mm;
            font-size:9.5pt;
            color:#003366;
            line-height:1.4;
        }
    </style>
</head>
<body onload="window.print()">

<?php $__currentLoopData = $records; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $r): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <div class="page">
        <!-- Header -->
        <div class="header">
            <img src="<?php echo e(asset('images/ttd_header.png')); ?>" alt="TTD Header">
        </div>

        <!-- Receipt Box -->
        <div class="box">
            <div class="two">
                <div class="line"><span class="lbl">Receipt No:</span> <?php echo e($r->receipt_no); ?></div>
                <div class="line right"><span class="lbl">Date:</span> <?php echo e(now()->format('d/m/Y')); ?></div>
            </div>
            <div class="line"><span class="lbl">Name:</span> <?php echo e($r->sender_name); ?></div>
            <div class="line"><span class="lbl">Address:</span> <?php echo e($r->sender_address); ?></div>
            <div class="line"><span class="lbl">Pincode:</span> <?php echo e($r->sender_pincode); ?></div>
            <div class="line"><span class="lbl">EMO Number:</span> <?php echo e($r->emo_number); ?></div>
            <div class="line"><span class="lbl">Amount:</span> ₹<?php echo e(number_format($r->emo_amount, 2)); ?></div>
            <?php if($r->emo_message): ?>
                <div class="line"><span class="lbl">Message:</span> <?php echo e($r->emo_message); ?></div>
            <?php endif; ?>
        </div>

        <!-- Blessing -->
        <div class="blessing">
            "May Lord Venkateswara Shower His Blessings"
        </div>

        <!-- Signature -->
        <div class="sign">
            In the Service of Lord Venkateswara<br>
            <b>Executive Officer</b>
        </div>

        <!-- Footer -->
        <div class="footer">
            Encl: Swamyvari Photo and Akshinthalu <br>
            This is computer generated and does not bear signature <br>
            <span>Department of Posts - Govt. of India</span>
        </div>
    </div>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

</body>
</html>
<?php /**PATH C:\project\laravel_project\emo-receipts\resources\views/emo/pdf.blade.php ENDPATH**/ ?>