<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-2xl text-gray-800 flex items-center gap-2">
            📊 <span>Dashboard</span>
        </h2>
    </x-slot>

    <div class="py-10 max-w-7xl mx-auto">
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">

            {{-- File Uploads Today --}}
            <div class="bg-[#1b1b18] text-white p-6">
                <div class="flex items-center justify-between">
                    <div>
                        <h3 class="text-3xl font-bold">{{ $uploadsToday }}</h3>
                        <p class="text-sm opacity-90">File Uploads Today</p>
                    </div>
                    <div class="h-12 w-12 flex items-center justify-center bg-white/20 rounded-full">
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                  d="M4 4v16h16V4M4 4l8 8m0 0l8-8m-8 8v12"/>
                        </svg>
                    </div>
                </div>
            </div>

            {{-- Records Uploaded Today --}}
            <div class="bg-indigo-50 shadow-lg rounded-xl p-6 text-red">
                <div class="flex items-center justify-between">
                    <div>
                        <h3 class="text-3xl font-bold">{{ $recordsToday }}</h3>
                        <p class="text-sm opacity-90">Records Uploaded Today</p>
                    </div>
                    <div class="h-12 w-12 flex items-center justify-center bg-white/20 rounded-full">
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                  d="M9 17v-6h13M5 13H3m6 8V5h4m2 0h2m2 0h2"/>
                        </svg>
                    </div>
                </div>
            </div>

            {{-- Past File Uploads --}}
            <div class="bg-gray-500 shadow-lg rounded-xl p-6 text-white">
                <div class="flex items-center justify-between">
                    <div>
                        <h3 class="text-3xl font-bold">{{ $uploadsPast }}</h3>
                        <p class="text-sm opacity-90">File Uploads (Past)</p>
                    </div>
                    <div class="h-12 w-12 flex items-center justify-center bg-white/20 rounded-full">
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                  d="M12 8v4l3 3m-6-3a9 9 0 1118 0 9 9 0 01-18 0z"/>
                        </svg>
                    </div>
                </div>
            </div>

            {{-- Past Records Uploaded --}}
            <div class="bg-red-600 shadow-lg rounded-xl p-6 text-white">
                <div class="flex items-center justify-between">
                    <div>
                        <h3 class="text-3xl font-bold">{{ $recordsPast }}</h3>
                        <p class="text-sm opacity-90">Records Uploaded (Past)</p>
                    </div>
                    <div class="h-12 w-12 flex items-center justify-center bg-white/20 rounded-full">
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                  d="M3 3h18M9 3v18m6-18v18"/>
                        </svg>
                    </div>
                </div>
            </div>

        </div>
    </div>
</x-app-layout>
