<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>EMO Application</title>
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">

    <style>
        /* Fade + slide animation */
        @keyframes fadeSlideIn {
            from {
                opacity: 0;
                transform: translateY(30px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        .fade-slide {
            animation: fadeSlideIn 0.8s ease-in-out;
        }
    </style>
</head>
<body class="bg-gradient-to-r from-indigo-300 via-indigo-400 to-indigo-500 flex items-center justify-center min-h-screen">

    <div class="w-full max-w-md bg-white rounded-2xl shadow-xl p-8 fade-slide">
        <!-- Logo -->
        <div class="text-center mb-6">
            <div class="mx-auto w-16 h-16 bg-indigo-500 text-white flex items-center justify-center rounded-full text-2xl font-bold shadow-md">
                EMO
            </div>
            <h2 class="mt-4 text-2xl font-bold text-gray-800">Welcome Back</h2>
            <p class="text-gray-500 text-sm">Sign in to continue to your account</p>
        </div>

        <!-- Form -->
        <form action="{{ route('login') }}" method="POST" class="space-y-5">
            @csrf

            <!-- Email -->
            <div>
                <label class="block text-sm font-medium text-gray-700">Email Address</label>
                <input type="email" name="email" class="mt-2 w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-indigo-400 focus:outline-none" placeholder="Enter your email" required>
            </div>

            <!-- Password -->
            <div>
                <label class="block text-sm font-medium text-gray-700">Password</label>
                <input type="password" name="password" class="mt-2 w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-indigo-400 focus:outline-none" placeholder="Enter your password" required>
            </div>

            <!-- Remember Me -->
            <div class="flex items-center justify-between">
                <label class="flex items-center text-sm text-gray-600">
                    <input type="checkbox" class="mr-2"> Remember Me
                </label>
               <!-- <a href="{{ route('password.request') }}" class="text-sm text-indigo-500 hover:underline">Forgot Password?</a>-->
            </div>

            <!-- Login Button -->
            <button type="submit" class="w-full py-3 bg-indigo-500 text-white rounded-lg font-semibold shadow-md hover:bg-indigo-600 transition duration-300 transform hover:scale-105">
                Sign In
            </button>
        </form>
    </div>

</body>
</html>
