<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class InvoiceEmiDtlsModel extends Model
{
    protected $table = 'invoice_emi_dtls';
    protected $primaryKey = 'id';
    protected $fillable = [
        'invoice_emi_id',
        'emi_date',
        'emi_amount',
        'due_date',
        'paid_date',
        'paid_amount',
        'discount_amount',
        'penalty',
        'oprntl_flag',
        'total_amount',
        'remarks',
    ];
    public function invoice_emi()
    {
        return $this->belongsTo(InvoiceEmiModel::class, 'invoice_emi_id');
    }
}
